import { StateNode } from "@tldraw/editor";
class Pointing extends StateNode {
  static id = "pointing";
  onEnter = () => {
    this.editor.stopCameraAnimation();
    this.editor.setCursor({ type: "grabbing", rotation: 0 });
  };
  onLongPress = () => {
    this.startDragging();
  };
  onPointerMove = () => {
    if (this.editor.inputs.isDragging) {
      this.startDragging();
    }
  };
  startDragging() {
    this.parent.transition("dragging");
  }
  onPointerUp = () => {
    this.complete();
  };
  onCancel = () => {
    this.complete();
  };
  onComplete = () => {
    this.complete();
  };
  onInterrupt = () => {
    this.complete();
  };
  complete() {
    this.parent.transition("idle");
  }
}
export {
  Pointing
};
//# sourceMappingURL=Pointing.mjs.map
